/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.network;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.badge.ServerPlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TcdcServerPlayNetworkHandler {
    private static final class_2960 CUSTOM_DATA_ID = class_2960.method_60655((String)TCDCommons.getModID(), (String)"server_play_network_handler");
    private final class_3222 player;

    private TcdcServerPlayNetworkHandler(class_3222 player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
    }

    public final class_3222 getPlayer() {
        return this.player;
    }

    public final void sendCustomPayloadNetwork(class_2960 id, ByteBuf buffer) throws IllegalStateException, NullPointerException {
        Objects.requireNonNull(id);
        Objects.requireNonNull(buffer);
        if (buffer.refCnt() < 1) {
            throw new IllegalStateException("REF_CNT");
        }
        CustomPayloadNetwork.sendS2C(this.player, id, buffer);
    }

    public final boolean sendPlayerBadges() {
        return ServerPlayerBadgeHandler.getServerBadgeHandler(this.player).sendStats(this.player);
    }

    public static final TcdcServerPlayNetworkHandler of(class_3222 player) throws NullPointerException {
        GenericProperties<class_2960> cd = EntityHooks.getCustomData((class_1297)Objects.requireNonNull(player));
        @Nullable TcdcServerPlayNetworkHandler spnh = (TcdcServerPlayNetworkHandler)cd.getProperty(CUSTOM_DATA_ID);
        if (spnh == null) {
            spnh = new TcdcServerPlayNetworkHandler(player);
            cd.setProperty(CUSTOM_DATA_ID, spnh);
        }
        return spnh;
    }
}

